using System;
using gov.va.med.vbecs.GUI.controls;
using gov.va.med.vbecs.Lock;

namespace gov.va.med.vbecs.admin.GUI.LockB
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Stas Antropov</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>3/18/2005</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	/// <summary>
	/// VBECS Administrator application single user mode lock class. Ensures that 
	/// no VBECS application instances are running at the server when VBECS 
	/// Administrator is switching to single user mode. 
	/// </summary>

	#endregion

	public class VbecsAdminSingleUserModeLock : SyncLockBase
	{		
        private SharedMutex _adminSingleUserModeGlobalMutex;

		/// <summary>
		/// Creates new locks and checks if there're an existing locks.
		/// </summary>
		public VbecsAdminSingleUserModeLock() : base() {}

		/// <summary>
		/// Obtains new locks and checks for existing locks. 
		/// </summary>
		protected override void ObtainAppSpecificGlobalLocks()
		{
            // check if there's another instance of VBECS running in the user session.
            bool vbecsIsNotRunningOnTheServer;
            using (new SharedMutex(Common.VbecsConfig.Current.EnvironmentType.ToUpper() == "M" ? GlobalTestVbecsSyncToken : GlobalProdVbecsSyncToken, out vbecsIsNotRunningOnTheServer)) { }
            if (!vbecsIsNotRunningOnTheServer)
                throw new AppLockingException(Common.StrRes.SysErrMsg.MUC01.VbecsIsRunningOnTheServer());

            // no check necessary here. Only 1 admin VBECS admin application can be run on the server => 2 sigle locks at the same time are not possible.
            _adminSingleUserModeGlobalMutex = new SharedMutex(Common.VbecsConfig.Current.EnvironmentType.ToUpper() == "M" ? GlobalAdminTestSingleUserModeSyncToken : GlobalAdminProdSingleUserModeSyncToken);
		}

		/// <summary>
		/// Releases locks.
		/// </summary>
		protected override void ReleaseAppSpecificGlobalLocks()
		{
            if (_adminSingleUserModeGlobalMutex != null)
                _adminSingleUserModeGlobalMutex.Dispose();
		}

	}
}